/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWFieldType;
import filenet.vw.api.VWModeType;
import filenet.vw.api.VWParameterDefinition;
import filenet.vw.api.VWStepDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.images.VWImageLoader;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.steps.VWCaseParameterInfo;
import filenet.vw.toolkit.design.property.tables.IVWParamExpressionCellEditorTableModel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.vw.toolkit.utils.table.VWToolTipTableCellItem;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.table.AbstractTableModel;

public class VWParametersTableModel
extends AbstractTableModel
implements IVWParamExpressionCellEditorTableModel {
    private static final int NUM_COLUMNS = 5;
    public static final int COL_NAME = 0;
    public static final int COL_TYPE = 1;
    public static final int COL_MODE = 2;
    public static final int COL_ISEXPRESSION = 3;
    public static final int COL_EXPRESSION = 4;
    public static final int COL_DESCRIPTION = 5;
    private static final String STR_ARRAY = "[ ]";
    private Vector<VWParameterDefinition> m_rowData = null;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWStepDefinition m_stepDefinition = null;
    private JComboBox m_fieldTypeComboBox = null;
    private JComboBox m_modeTypeComboBox = null;
    private VWToolTipTableCellItem m_expressionCellItem = null;
    private VWToolTipTableCellItem m_fieldCellItem = null;
    private int m_nType = 4;
    private boolean m_bIsArray = false;
    private int m_nMode = 3;
    private String m_expression = "";
    private String m_description = null;

    public VWParametersTableModel(VWAuthPropertyData authPropertyData, VWStepDefinition stepDef) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_stepDefinition = stepDef;
            this.m_rowData = new Vector();
            this.m_expressionCellItem = new VWToolTipTableCellItem();
            this.m_expressionCellItem.setIcon(VWImageLoader.createImageIcon("expression.gif"));
            this.m_expressionCellItem.setText(VWResource.s_editableExpression);
            this.m_fieldCellItem = new VWToolTipTableCellItem();
            this.m_fieldCellItem.setText(VWResource.s_readOnlyExpression);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void init(VWStepDefinition stepDef) {
        this.m_stepDefinition = stepDef;
        this.reinitialize();
    }

    public JComboBox getFieldTypeComboBox() {
        try {
            if (this.m_fieldTypeComboBox == null) {
                this.m_fieldTypeComboBox = new JComboBox();
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(32));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(32) + STR_ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(4) + STR_ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(8) + STR_ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(512));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(512) + STR_ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(1) + STR_ARRAY);
                this.m_fieldTypeComboBox.addItem(VWResource.s_workflowGroup);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(2) + STR_ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(16));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(16) + STR_ARRAY);
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(128));
                this.m_fieldTypeComboBox.addItem(VWFieldType.getLocalizedString(128) + STR_ARRAY);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_fieldTypeComboBox;
    }

    public JComboBox getModeTypeComboBox() {
        try {
            if (this.m_modeTypeComboBox == null) {
                this.m_modeTypeComboBox = new JComboBox();
                this.m_modeTypeComboBox.addItem(VWModeType.getLocalizedString(1));
                this.m_modeTypeComboBox.addItem(VWModeType.getLocalizedString(3));
                this.m_modeTypeComboBox.addItem(VWModeType.getLocalizedString(2));
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return this.m_modeTypeComboBox;
    }

    public int getTypeFromString(String type) {
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(32)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(32) + STR_ARRAY) == 0) {
                return 32;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(4)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(4) + STR_ARRAY) == 0) {
                return 4;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(8)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(8) + STR_ARRAY) == 0) {
                return 8;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(512)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(512) + STR_ARRAY) == 0) {
                return 512;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(1)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(1) + STR_ARRAY) == 0) {
                return 1;
            }
            if (VWStringUtils.compare(type, VWResource.s_workflowGroup) == 0) {
                return 64;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(2)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(2) + STR_ARRAY) == 0) {
                return 2;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(16)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(16) + STR_ARRAY) == 0) {
                return 16;
            }
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(128)) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(128) + STR_ARRAY) == 0) {
                return 128;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }

    public boolean getIsArrayType(String type) {
        boolean result = false;
        try {
            if (VWStringUtils.compare(type, VWFieldType.getLocalizedString(32) + STR_ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(4) + STR_ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(8) + STR_ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(1) + STR_ARRAY) == 0 || VWStringUtils.compare(type, VWResource.s_workflowGroup) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(2) + STR_ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(16) + STR_ARRAY) == 0 || VWStringUtils.compare(type, VWFieldType.getLocalizedString(128) + STR_ARRAY) == 0) {
                result = true;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return result;
    }

    public void deleteItems(int[] rows) {
        try {
            int rowsCount;
            if (this.m_stepDefinition != null && rows != null && (rowsCount = rows.length) > 0) {
                ArrayList<VWParameterDefinition> paramDefList = new ArrayList<VWParameterDefinition>();
                for (int i = rowsCount - 1; i >= 0; --i) {
                    int row = rows[i];
                    VWParameterDefinition paramDef = this.getItemAt(row);
                    if (paramDef == null) continue;
                    this.m_rowData.removeElementAt(row);
                    this.m_stepDefinition.deleteParameter(paramDef.getName());
                    paramDefList.add(paramDef);
                    this.fireTableRowsDeleted(row, row);
                }
                VWCaseParameterInfo.removePostAssignments(paramDefList.toArray(new VWParameterDefinition[0]), this.m_stepDefinition);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteItem(int nRowIndex) {
        try {
            VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
            if (this.m_stepDefinition != null && paramDef != null) {
                this.m_rowData.removeElementAt(nRowIndex);
                this.m_stepDefinition.deleteParameter(paramDef.getName());
                this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                this.m_authPropertyData.setDirty();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void reinitialize() {
        try {
            int parameterCount;
            VWParameterDefinition[] parameters;
            this.m_expression = "";
            this.m_rowData.removeAllElements();
            if (this.m_stepDefinition != null && (parameters = this.m_stepDefinition.getParameterDefinitions()) != null && (parameterCount = parameters.length) > 0) {
                for (int i = 0; i < parameterCount; ++i) {
                    this.m_rowData.addElement(parameters[i]);
                }
            }
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public VWParameterDefinition getItemAt(int nRowIndex) {
        if (this.m_rowData == null) {
            return null;
        }
        if (this.m_rowData != null && nRowIndex >= 0 && nRowIndex < this.m_rowData.size()) {
            return this.m_rowData.elementAt(nRowIndex);
        }
        return null;
    }

    public int getParameterType(int nRowIndex) {
        VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getDataType();
        }
        return this.m_nType;
    }

    public boolean getIsArray(int nRowIndex) {
        VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getIsArray();
        }
        return this.m_bIsArray;
    }

    public int getMode(int nRowIndex) {
        VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
        if (paramDef != null) {
            return paramDef.getMode();
        }
        return this.m_nMode;
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return String.class;
            }
            case 3: {
                return VWToolTipTableCellItem.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 5;
    }

    public String getColumnName(int nColumnIndex) {
        String columnName = null;
        switch (nColumnIndex) {
            case 0: {
                columnName = VWResource.s_nameStr;
                break;
            }
            case 1: {
                columnName = VWResource.s_type;
                break;
            }
            case 2: {
                columnName = VWResource.s_accessRights;
                break;
            }
            case 3: {
                columnName = null;
                break;
            }
            case 4: {
                columnName = VWResource.s_expressionStr;
                break;
            }
            case 5: {
                columnName = VWResource.s_description;
            }
        }
        return columnName;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    if (paramDef == null) break;
                    return paramDef.getName();
                }
                case 1: {
                    int nType = this.m_nType;
                    boolean bIsArray = this.m_bIsArray;
                    if (paramDef != null) {
                        nType = paramDef.getDataType();
                        bIsArray = paramDef.getIsArray();
                    }
                    if (bIsArray) {
                        if (nType == 64) {
                            return VWResource.s_workflowGroupStr;
                        }
                        return VWFieldType.getLocalizedString(nType) + STR_ARRAY;
                    }
                    return VWFieldType.getLocalizedString(nType);
                }
                case 2: {
                    if (paramDef != null) {
                        return VWModeType.getLocalizedString(paramDef.getMode());
                    }
                    return VWModeType.getLocalizedString(this.m_nMode);
                }
                case 3: {
                    return this.getExpressionCellItem(paramDef);
                }
                case 4: {
                    if (paramDef != null) {
                        return paramDef.getValue();
                    }
                    return this.m_expression;
                }
                case 5: {
                    if (paramDef != null) {
                        return paramDef.getDescription();
                    }
                    return this.m_description;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: 
            case 2: 
            case 4: 
            case 5: {
                return true;
            }
            case 1: {
                String value = (String)this.getValueAt(nRowIndex, 4);
                return value == null || this.m_authPropertyData == null || this.m_authPropertyData.getField(value) == null;
            }
            case 3: {
                return false;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        try {
            switch (nColumnIndex) {
                case 0: {
                    this.onUpdateName(aValue, nRowIndex);
                    break;
                }
                case 1: {
                    this.onUpdateType(aValue, nRowIndex);
                    break;
                }
                case 2: {
                    this.onUpdateMode(aValue, nRowIndex);
                    break;
                }
                case 4: {
                    this.onUpdateExpression(aValue, nRowIndex);
                    break;
                }
                case 5: {
                    this.onUpdateDescription(aValue, nRowIndex);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void onUpdateName(Object aValue, int nRowIndex) {
        block10: {
            try {
                String newName;
                if (aValue != null && aValue instanceof String && this.m_stepDefinition != null && (newName = (String)aValue).length() > 0) {
                    VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
                    if (paramDef != null) {
                        if (VWStringUtils.compare(newName, paramDef.getName()) != 0) {
                            paramDef.setName(newName);
                        }
                        paramDef.setMode(1);
                        if (this.m_authPropertyData != null) {
                            this.m_authPropertyData.setDirty();
                        }
                        this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                    } else {
                        int nType = this.m_nType;
                        boolean bIsArray = this.m_bIsArray;
                        int nMode = this.m_nMode;
                        String expression = this.m_expression;
                        String description = this.m_description;
                        if (this.m_authPropertyData != null && this.m_authPropertyData.getField(newName) != null) {
                            VWFieldDefinition fieldDef = this.m_authPropertyData.getField(newName);
                            nType = fieldDef.getFieldType();
                            bIsArray = fieldDef.isArray();
                            expression = newName;
                            description = fieldDef.getDescription();
                        } else {
                            nMode = 1;
                        }
                        paramDef = this.m_stepDefinition.createParameter(newName, nMode, expression, nType, bIsArray);
                        if (paramDef != null) {
                            paramDef.setDescription(description);
                            this.m_rowData.addElement(paramDef);
                            this.m_authPropertyData.setDirty();
                            this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block10;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    private void onUpdateType(Object aValue, int nRowIndex) {
        block6: {
            try {
                if (aValue != null && aValue instanceof String) {
                    String type = (String)aValue;
                    if (type.length() > 0) {
                        int nType = this.getTypeFromString(type);
                        boolean bIsArray = this.getIsArrayType(type);
                        VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
                        if (paramDef != null) {
                            paramDef.setDataType(nType);
                            paramDef.setIsArray(bIsArray);
                            this.m_authPropertyData.setDirty();
                        } else {
                            this.m_nType = nType;
                            this.m_bIsArray = bIsArray;
                        }
                    }
                    this.fireTableCellUpdated(nRowIndex, 1);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    private void onUpdateMode(Object aValue, int nRowIndex) {
        block6: {
            try {
                if (aValue != null && aValue instanceof String) {
                    String mode = (String)aValue;
                    if (mode.length() > 0) {
                        int nMode = this.getModeFromString(mode);
                        VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
                        if (paramDef != null) {
                            paramDef.setMode(nMode);
                            this.m_authPropertyData.setDirty();
                        } else {
                            this.m_nMode = nMode;
                        }
                    }
                    this.fireTableCellUpdated(nRowIndex, 2);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    private void onUpdateExpression(Object aValue, int nRowIndex) {
        block7: {
            try {
                if (aValue != null && aValue instanceof String) {
                    String expression = (String)aValue;
                    if (expression.length() > 0) {
                        VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
                        if (paramDef != null) {
                            paramDef.setValue(expression);
                            this.m_authPropertyData.setDirty();
                        } else {
                            this.m_expression = expression;
                        }
                    }
                    this.fireTableRowsUpdated(nRowIndex, nRowIndex);
                }
            }
            catch (NumberFormatException nfex) {
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block7;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    private void onUpdateDescription(Object aValue, int nRowIndex) {
        block6: {
            try {
                if (aValue != null && aValue instanceof String) {
                    String description = (String)aValue;
                    if (description.length() > 0) {
                        VWParameterDefinition paramDef = this.getItemAt(nRowIndex);
                        if (paramDef != null) {
                            paramDef.setDescription(description);
                            this.m_authPropertyData.setDirty();
                        } else {
                            this.m_description = description;
                        }
                    }
                    this.fireTableCellUpdated(nRowIndex, 1);
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block6;
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    private VWToolTipTableCellItem getExpressionCellItem(VWParameterDefinition paramDef) {
        if (paramDef != null && this.m_authPropertyData != null) {
            if (this.m_authPropertyData.getField(paramDef.getValue()) != null) {
                return this.m_fieldCellItem;
            }
            return this.m_expressionCellItem;
        }
        return null;
    }

    private int getModeFromString(String mode) {
        try {
            if (VWStringUtils.compare(mode, VWModeType.getLocalizedString(1)) == 0) {
                return 1;
            }
            if (VWStringUtils.compare(mode, VWModeType.getLocalizedString(2)) == 0) {
                return 2;
            }
            if (VWStringUtils.compare(mode, VWModeType.getLocalizedString(3)) == 0) {
                return 3;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return -1;
    }
}

